//To plot continuous time fourier transorm of a continuous time signal
//scilab 5.4.1;64 bit(windows 8)
clc;
clear;
A=1;// Amplitude
Dt=0.005;
t1=-4.5:Dt:4.5;
xt1=exp(-A*abs(t1));
// Continuous time Fourier Transform
Wmax1 =2*%pi*1;// Analog Frequency = 1Hz
K=4;
k=0:(K/1000):K;
W1=k*Wmax1/K;
XW1=xt1*exp(-sqrt(-1)*t1'*W1)*Dt;
XW1=real(XW1);
W1=[-mtlb_fliplr(W1), W1(2:1001) ]; // Omega from -Wmax to Wmax
XW1=[ mtlb_fliplr(XW1), XW1(2:1001) ];
subplot(2 ,1 ,1);
b=gca();
b.y_location = "origin";
plot2d(t1,xt1,3);
xlabel('t in sec.');
ylabel('x(t)')
title(' Continuous Time Signal')
subplot(2 ,1 ,2);
b =gca();
b.y_location = "origin";
plot2d(W1,XW1,5);
xlabel('Frequency in Radians / Seconds W');
ylabel('X(jW)')
title('Continuous time Fourier Transform ')
mprintf('|F(w)|= 2*a/sqrt(a^2+w^2) and\n Theta(w)=0')
